/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.util;

import java.util.Map;
import net.ftb.data.Settings;
import net.ftb.gui.LaunchFrame;
import net.ftb.log.Logger;
import net.ftb.tracking.piwik.PiwikTracker;

public class TrackerUtils {
    public static boolean googleEnabled = true;
    public static boolean piwikEnabled = true;

    public static void sendPageView(String pageUrl, String pageTitle) {
        TrackerUtils.sendPageView(pageUrl, pageTitle, null);
    }

    public static void sendPageView(String pageUrl, String pageTitle, Map<String, String> extraData) {
        if (!Settings.getSettings().getSnooper()) {
            if (googleEnabled) {
                LaunchFrame.tracker.trackPageViewFromReferrer(pageUrl, pageTitle, "Feed The Beast", "http://www.feed-the-beast.com", "/");
            }
            if (piwikEnabled) {
                try {
                    PiwikTracker p = new PiwikTracker(pageTitle, pageUrl);
                    if (extraData != null) {
                        for (Map.Entry<String, String> s : extraData.entrySet()) {
                            p.addExtraPair(s.getKey(), s.getValue());
                        }
                    }
                    p.start();
                }
                catch (Exception e) {
                    Logger.logError(e.getMessage(), e);
                }
            }
        }
    }
}

